/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.ws.api.WSOperation;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class VWOperationListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_simpleModeIcon = null;
    private ImageIcon m_advancedModeIcon = null;
    private VWWebServiceUtils m_wsUtils = null;

    public VWOperationListCellRenderer(VWWebServiceUtils wsUtils) {
        try {
            this.setOpaque(true);
            this.m_wsUtils = wsUtils;
            this.m_simpleModeIcon = VWImageLoader.createImageIcon("basic_operation.gif");
            this.m_advancedModeIcon = VWImageLoader.createImageIcon("advanced_operation.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            this.setComponentOrientation(list.getComponentOrientation());
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null && value instanceof WSOperation) {
                WSOperation operation = (WSOperation)value;
                if (this.m_wsUtils.isSimpleOperation(operation)) {
                    this.setIcon(this.m_simpleModeIcon);
                } else {
                    this.setIcon(this.m_advancedModeIcon);
                }
                this.setText(operation.getDisplayName());
            } else if (value != null && value instanceof String) {
                this.setIcon(null);
                this.setText((String)value);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

